﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.UpdateClinic
{
    /// <summary>
    /// Serialize Clinic step.
    /// </summary>
    public class SerializeClinicStep : FilterBase<UpdateClinicStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(UpdateClinicStateObject state)
        {
            try
            {
                state.SerializedRequestMessage = PipelineUtilities.SerializeInstance(state.RequestMessage);
                Logger.Instance.Info(string.Format("INFO: HealthShare Update Clinic Data: {0}", state.SerializedRequestMessage));
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Update Clinic SerializeAppointmentStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}